import { Router, Request, Response } from 'express';
import pool from '../../config/database';
import { generateToken, authenticateToken } from '../../middleware/auth';
import { hashPassword, verifyPassword } from '../../utils/password';
import { ResultSetHeader } from 'mysql2';
const router = Router();

// // Add User (Register)
// router.post('/register', async (req: Request, res: Response) => {
//     const { username, email, password } = req.body;
  
//     if (!password) {
//       return res.status(400).json({ message: 'Password is required' });
//     }
  
//     try {
//       const { salt, hash } = await hashPassword(password);
//       const [result] = await pool.query<ResultSetHeader>(
//         'INSERT INTO users (username, email, password) VALUES (?, ?, ?)',
//         [username, email, `${salt}:${hash}`]
//       );
//       res.status(201).json({ message: 'User registered successfully', userId: result.insertId });
//     } catch (err) {
//       res.status(500).json({ message: 'Error registering user', error: (err as Error).message });
//     }
//   });
  
router.post('/register', async (req: Request, res: Response) => {
    console.log(req.body);  // Log the request body to ensure it contains the expected fields
    
    const { username, email, password } = req.body;
    
    if (!password) {
        return res.status(400).json({ message: 'Password is required' });
    }

    try {
      const { salt, hash } = await hashPassword(password);
      
      const [result] = await pool.query<ResultSetHeader>(
        'INSERT INTO users (username, email, password) VALUES (?, ?, ?)',
        [username, email, `${salt}:${hash}`]
      );
      
      res.status(201).json({ message: 'User registered successfully', userId: result.insertId });
    } catch (err) {
      res.status(500).json({ message: 'Error registering user', error: (err as Error).message });
    }
});

// // Login User
// router.post('/login', async (req: Request, res: Response) => {
//   const { email, password } = req.body;
//   try {
//     const [rows] = await pool.query('SELECT * FROM users WHERE email = ?', [email]);
//     const user = (rows as any[])[0];

//     if (!user) return res.status(400).json({ message: 'Invalid email or password' });

//     const [salt, storedHash] = user.password.split(':');
//     const validPassword = await verifyPassword(password, salt, storedHash);
//     if (!validPassword) return res.status(400).json({ message: 'Invalid email or password' });

//     const token = generateToken(user.id);
//     res.status(200).json({ message: 'Login successful', token });
//   } catch (err) {
//     res.status(500).json({ message: 'Error logging in', error: (err as Error).message });
//   }
// });

router.post('/login', async (req: Request, res: Response) => {
    const { email, password } = req.body;
    console.log('Login attempt with email:', email);
  
    try {
      const [rows] = await pool.query('SELECT * FROM users WHERE email = ?', [email]);
      const user = (rows as any[])[0];
      console.log('User found:', user);
  
      if (!user) {
        return res.status(400).json({ message: 'Invalid email or password' });
      }
  
      const [salt, storedHash] = user.password.split(':');
      const validPassword = await verifyPassword(password, salt, storedHash);
      console.log('Password verification result:', validPassword);
  
      if (!validPassword) {
        return res.status(400).json({ message: 'Invalid email or password' });
      }
  
      const token = generateToken(user.id);
      res.status(200).json({ message: 'Login successful', token });
    } catch (err) {
      console.error('Error during login:', err);
      res.status(500).json({ message: 'Error logging in', error: (err as Error).message });
    }
  });
  
// Update User
router.put('/users/:id', authenticateToken, async (req: Request, res: Response) => {
  const { id } = req.params;
  const { username, email, password } = req.body;
  try {
    const { salt, hash } = await hashPassword(password);
    await pool.query(
      'UPDATE users SET username = ?, email = ?, password = ? WHERE id = ?',
      [username, email, `${salt}:${hash}`, id]
    );
    res.status(200).json({ message: 'User updated successfully' });
  } catch (err) {
    res.status(500).json({ message: 'Error updating user', error: (err as Error).message });
  }
});

// Get All Users
router.get('/users', async (req: Request, res: Response) => {
    try {
        const [rows] = await pool.query('SELECT * FROM users');
        res.status(200).json(rows);
    } catch (err) {
        res.status(500).json({ message: 'Error retrieving users', error: (err as Error).message });
    }
});
// Delete User
router.delete('/users/:id', authenticateToken, async (req: Request, res: Response) => {
  const { id } = req.params;
  try {
    await pool.query('DELETE FROM users WHERE id = ?', [id]);
    res.status(200).json({ message: 'User deleted successfully' });
  } catch (err) {
    res.status(500).json({ message: 'Error deleting user', error: (err as Error).message });
  }
});

export default router;
