import { Request, Response, NextFunction } from 'express';
import jwt from 'jsonwebtoken';
console.log(jwt)
const secretKey = '87a1f83aa5b4dff22d26cba74ad7d2ccc4bbb7380e6581c8ce04333ccacbac1e';

export const generateToken = (userId: number) => {
  return jwt.sign({ userId }, secretKey, { expiresIn: '1h' }); 
};

export const authenticateToken = (req: Request, res: Response, next: NextFunction) => {
  const token = req.header('Authorization')?.split(' ')[1];
  if (!token) return res.status(401).json({ message: 'Access denied, no token provided' });

  try {
    const verified = jwt.verify(token, secretKey) as { userId: number };
    req.body.userId = verified.userId;
    next();
  } catch (err) {
    res.status(400).json({ message: 'Invalid token' });
  }
};
